﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System.Xml.Linq;
using UnityEngine.UI;

public class SppMenuData : MonoBehaviour {
	public bool showOnlineData = true;
	public SppDownloadManager downloadManager;
	public SppModelLoader modelLoader;
	public SppMenuEntry[] offlineItems;
	public SppMenuEntry[] onlineItems;
	public RectTransform rtContent;
	public GridLayoutGroup gridLayoutGroup;
	public Button referenceButton;

	protected SppMenuEntry[] items;

	void Start () {
        if (showOnlineData == true)
        {
            RequestOnlineData();
        }
        else
        {
            ReadOfflineData();
        }
	}

	#region UI
	public virtual void PopulateUI() {

		if (showOnlineData) {
			items = onlineItems;
		} else {
			items = offlineItems;
		}
		if (gridLayoutGroup != null && referenceButton != null) {
			
			for (int i = 0; i < items.Length; i++) {
				Button newButton = Instantiate(referenceButton);
				newButton.name = "Button" + i.ToString ("d6");
				newButton.gameObject.SetActive (true);
				Text[] txts = newButton.GetComponentsInChildren<Text> ();
				txts [0].text = items [i].name;
				newButton.onClick.AddListener (delegate {
					OnClick (newButton);

				});
				newButton.transform.SetParent (gridLayoutGroup.transform);
				newButton.transform.localScale = Vector3.one;
			}	
		rtContent.sizeDelta = new Vector3 (rtContent.sizeDelta.x, items.Length * referenceButton.GetComponent<RectTransform>().sizeDelta.y);
		}	
	}	

	public virtual void OnClick(Button btn) {
		string name = btn.name;
		int idx = System.Convert.ToInt32 (name.Substring (name.Length - 6, 6));
		if (modelLoader != null) {
			if (showOnlineData) {
				modelLoader.Load (items [idx].url, "/");
			} else {
				modelLoader.LoadOffline (items [idx].url, "/");
			}	
		}	
	}

	#endregion

	#region offline
	string CombinePath(string prefix, string postfix) {
		if (!prefix.EndsWith("/"))
			prefix = prefix + "/";
		postfix = postfix.Trim('/');
		return (prefix+postfix);
	}

	public void ReadOfflineData() {
#if UNITY_WSA
        string offlinePath = "";
#else
        string offlinePath = System.Environment.GetFolderPath(System.Environment.SpecialFolder.Personal);
#endif
		offlinePath = CombinePath(offlinePath, "SparePartsPlace");
		offlinePath = CombinePath(offlinePath, "SPPV");
		offlinePath = offlinePath.Replace("\\", "/"); 

		System.IO.Directory.CreateDirectory(offlinePath); 
		string menuFile = CombinePath (offlinePath, "menu.xml");
		if (System.IO.File.Exists(menuFile)) {
			string xml = System.IO.File.ReadAllText (menuFile);
			ParseXML(xml, false);

            PopulateUI();
		} 	
	}
#endregion 			#endregion

#region online
	void RequestOnlineData() {
		string url = SppConfig.loginData.server + "/Unity/get_menu_fileversion_xml.php";
		url += "?action=get_menu_xml";
		url += "&company=" + SppConfig.loginData.catalog;
		url += "&user=" + SppConfig.loginData.user;
		url += "&password=" + SppConfig.loginData.password;
		url += "&caller=Unity3D";
		downloadManager.StopDownload ();
		downloadManager.DownloadFile (gameObject, "OnRequestFinished", url, false);
	}

	public void OnRequestFinished(SppWebData wd) {
		if (string.IsNullOrEmpty (wd.error)) {
			//Debug.Log (wd.text);
			ParseXML (wd.text, true);
			// Show online data in UI
			PopulateUI ();

        }
        else {
			Debug.LogError (wd.error);
		}	
	}	

	private bool ParseXML(string txt, bool online) {
		List<SppMenuEntry> menuItems = new List<SppMenuEntry> ();
		bool retVal = false;

		if (txt.Length>0) {
			try {
				XDocument xDoc = XDocument.Parse(txt);
				if (xDoc!=null) {
					XElement root  = xDoc.Root;
					if (root!=null) {
						if (online) {
							string valid;
							if ((string)root.Attribute("Valid") != null) 
								valid = root.Attribute("Valid").Value;
							else
								valid = "";
						} 
						foreach (XElement child in root.Elements()) {
							SppMenuEntry item = new SppMenuEntry();
							item.name = (string)child.Attribute("Name").Value;
							item.image = child.Attribute("Image").Value;
							item.url = child.Attribute("URL").Value;
							string[] subFolders = item.url.Split('/');
							item.url = subFolders[subFolders.Length-1];
							// NEW
							if ((string)child.Attribute("company") != null) 
								item.catalog = child.Attribute("company").Value;
							else
								item.catalog = "";

							if ((string)child.Attribute("order_script") != null) 
								item.order_script = child.Attribute("order_script").Value;
							else
								item.order_script = "";

							if ((string)child.Attribute("order_mail") != null) 
								item.order_mail = child.Attribute("order_mail").Value;
							else
								item.order_mail = "";

							if ((string)child.Attribute("requiresMailAddresses") != null) 
								item.requiresMailAddresses = child.Attribute("requiresMailAddresses").Value == "1";
							else
								item.requiresMailAddresses = true;

							if ((string)child.Attribute("purchase") != null) 
								item.canPurchase = child.Attribute("purchase").Value == "1";
							else
								item.canPurchase = false;

							if ((string)child.Attribute("Toolkit") != null) {
								item.toolkit = child.Attribute("Toolkit").Value == "1";

							} else
								item.toolkit = false;

							if ((string)child.Attribute("Projectname") != null) {
								item.projectName = child.Attribute("Projectname").Value;
							} else
								item.projectName = "";

							if (online) {
								item.server = SppConfig.loginData.server;
								menuItems.Add(item);
							} else {
								if ((string)child.Attribute("server") != null) 
									item.server = child.Attribute("server").Value;
								else
									item.server = "";
								menuItems.Add(item);
							}
						}
						retVal = true;
					} 
				}
			} catch {
				;
			}
		}
		if (online) {
			onlineItems = menuItems.ToArray();
		} else {
			offlineItems = menuItems.ToArray();
		}
		return retVal;	
	}

#endregion
}
